////////////////////////////////////////////////////////////////////////////////
//
// © 1999 – 2019 OneSpan North America Inc. All rights reserved.
// All rights reserved. https://www.onespan.com/
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN

/**
 * The {@link OrchestrationServerError} class is the base class used for asynchronous error management in
 * the Orchestration SDK.
 */

NS_REFINED_FOR_SWIFT
@interface OrchestrationServerError : NSObject

@property (nonatomic, readonly) NSString *readableMessage;
@property (nonatomic, readonly, nullable) NSString *customPayload;

- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;

/**
 * Constructor
 * @param readableMessage human readable message describing the error
 */
- (instancetype)initWithReadableMessage:(NSString*)readableMessage;

/**
 * Constructor
 * @param readableMessage human readable message describing the error
 * @param customPayload customPayload set by the server integrator which can contain any extra information on the error
 */
- (instancetype)initWithReadableMessage:(NSString*)readableMessage customPayload:(nullable NSString *)customPayload;

@end

NS_ASSUME_NONNULL_END
